<?php

namespace Drupal\shareholder_register\Plugin\views\field;

use Drupal\views\ResultRow;
use Drupal\views\Plugin\views\field\FieldPluginBase;

/**
 * A handler to provide display for the share count.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("shareholder_register_view_share_count")
 */
class ShareholderRegisterViewShareCount  extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    if (get_class($values->_entity) == 'Drupal\shareholder_register\Entity\Shareholder' || get_class($values->_entity) == 'Drupal\shareholder_register\Entity\ShareType') {
      return [
        '#markup' => $values->_entity->getShareCount(),
        '#cache' => [
          'tags' => \Drupal::entityTypeManager()->getDefinition('share_transaction')->getListCacheTags(),
        ],
      ];
    }
    return [
      '#markup' => '0',
      '#cache' => [
        'tags' => \Drupal::entityTypeManager()->getDefinition('share_transaction')->getListCacheTags(),
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function query() {
    // This function exists to override parent query function.
    // Do nothing.
  }
}
