<?php

namespace Drupal\shareholder_register;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Share entity.
 *
 * @see \Drupal\shareholder_register\Entity\Share.
 */
class ShareAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\shareholder_register\Entity\ShareInterface $entity */
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view all share entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit share entities');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete share entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add share entities');
  }

}
