<?php

namespace Drupal\shareholder_register;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Share entities.
 *
 * @ingroup shareholder_register
 */
class ShareListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['name'] = $this->t('Share Number');
    $header['par_value'] = $this->t('Par Value');
    $header['issue_premium'] = $this->t('Issue Premium');
    $header['state'] = $this->t('State');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var $entity \Drupal\shareholder_register\Entity\Share */

    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.share.canonical',
      ['share' => $entity->id()]
    );
    $row['par_value'] = $entity->getShareValue();
    $row['issue_premium'] = $entity->getIssuePremium();
    $row['state'] = $entity->getState();

    return $row + parent::buildRow($entity);
  }

}
