<?php

namespace Drupal\shareholder_register;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Share transaction entity.
 *
 * @see \Drupal\shareholder_register\Entity\ShareTransaction.
 */
class ShareTransactionAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\shareholder_register\Entity\ShareTransactionInterface $entity */
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view all share transaction entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit share transaction entities');

      case 'delete':
        if ($entity && $entity->get('state')->value !== 'cancel') {
          return AccessResult::forbidden();
        }
        return AccessResult::allowedIfHasPermission($account, 'delete share transaction entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add share transaction entities');
  }

}
