<?php

namespace Drupal\shareholder_register;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Share Transaction Group entity.
 *
 * @see \Drupal\shareholder_register\Entity\ShareTransactionGroup.
 */
class ShareTransactionGroupAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\shareholder_register\Entity\ShareTransactionGroupInterface $entity */
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view all share transaction group entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit share transaction group entities');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete share transaction group entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add share transaction group entities');
  }

}
