<?php

namespace Drupal\shareholder_register;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Share Transaction Group entities.
 *
 * @ingroup shareholder_register
 */
class ShareTransactionGroupListBuilder extends EntityListBuilder {


  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['id'] = $this->t('Share Transaction Group ID');
    $header['name'] = $this->t('Name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var $entity \Drupal\shareholder_register\Entity\ShareTransactionGroup */
    $row['id'] = $entity->id();
    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.share_transaction_group.edit_form',
      ['share_transaction_group' => $entity->id()]
    );
    return $row + parent::buildRow($entity);
  }

}
