<?php

namespace Drupal\shareholder_register;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Shareholder entity.
 *
 * @see \Drupal\shareholder_register\Entity\Shareholder.
 */
class ShareholderAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\shareholder_register\Entity\ShareholderInterface $entity */
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view all shareholder entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit shareholder entities');

      case 'delete':
        if ($entity && $entity->get('state')->value !== 'cancel') {
          return AccessResult::forbidden();
        }
        return AccessResult::allowedIfHasPermission($account, 'delete shareholder entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add shareholder entities');
  }

}
