<?php

namespace Drupal\shareholder_register;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Shareholder entities.
 *
 * @ingroup shareholder_register
 */
class ShareholderListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['number'] = $this->t('Shareholder Number');
    $header['name'] = $this->t('Name');
    $header['identifier'] = $this->t('Identifier');
    $header['mail'] = $this->t('Mail');
    $header['date_of_registration'] = $this->t('Date of Registration');
    $header['number_of_shares_held'] = $this->t('Current Number of Shares');
    $header['value_of_shares_held'] = $this->t('Current Value of Shares');
    $header['shares'] = $this->t('Shares');
    $header['address'] = $this->t('Address');
    $header['state'] = $this->t('State');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var $entity \Drupal\shareholder_register\Entity\Shareholder */

    $row['number'] = $entity->getNumber();
    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.shareholder.canonical',
      ['shareholder' => $entity->id()]
    );
    $row['identifier'] = $entity->getIdentifier();
    $row['mail'] = $entity->getMail();
    $row['date_of_registration'] = $entity->getRegistrationDate();
    $row['number_of_shares_held'] = $entity->getShareCount();
    $row['value_of_shares_held'] = $entity->getShareTotalValue();
    $row['shares'] = \Drupal::service('shareholder_register.formatter')->shareIdsToRanges(
      $entity->getShareIds());
    $row['address'] = $entity->getFormattedAddress();
    $row['state'] = $entity->getState();

    return $row + parent::buildRow($entity);
  }

  /**
   * Gets Shareholders default operations.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity the operations are for.
   *
   * @return array
   *   The array structure is identical to the return value of
   *   self::getOperations().
   */
  protected function getDefaultOperations(EntityInterface $entity) {
    $operations = parent::getDefaultOperations($entity);

    $operations['view'] = array(
      'title' => $this
        ->t('View'),
      'weight' => 1,
      'url' => $entity
        ->urlInfo('canonical'),
    );

    $operations['shareholder-register-certificate'] = [
      'title' => $this->t('Register Certificate'),
      'weight' => 20,
      'url' => $entity->urlInfo('certificate'),
    ];

    return $operations;
  }
}
