<?php
namespace Drupal\shareholder_register;

use Drupal\shareholder_register\Entity\Shareholder;


class ShareholderSharesLine {

  /**
   * The shareholder ID.
   *
   * @var int
   */
  protected $shareholder_id;

  /**
   * The date.
   *
   * @var string
   */
  protected $date;

  /**
   * The Quantity.
   *
   * @var int
   */
  protected $quantity;

  /**
   * The share IDS.
   *
   * @var array
   */
  protected $share_ids;

  /**
   * The share hash.
   *
   * @var string
   */
  protected $share_hash;

  /**
   * Constructs a new ShareholderSharesLine object.
   */
  public function __construct(string $date, int $shareholder_id, int $quantity, array $share_ids, string $share_hash) {
    $this->date = $date;
    $this->shareholder_id = $shareholder_id;
    $this->quantity = $quantity;
    $this->share_ids = $share_ids;
    $this->share_hash = $share_hash;
  }

  public function getDate() {
    return $this->date;
  }

  public function getShareholder() {
    return Shareholder::load($this->shareholder_id);
  }

  public function getShareholderId() {
    return $this->shareholder_id;
  }

  public function getQuantity() {
    return $this->quantity;
  }

  public function getShareIds() {
    return $this->share_ids;
  }

  public function getShareHash() {
    return $this->share_hash;
  }
}
