<?php

namespace Drupal\shareholder_register;

use Drupal\Core\Entity\Sql\SqlContentEntityStorage;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Language\LanguageInterface;
use Drupal\shareholder_register\Entity\ShareholderInterface;

/**
 * Defines the storage handler class for Shareholder entities.
 *
 * This extends the base storage class, adding required special handling for
 * Shareholder entities.
 *
 * @ingroup shareholder_register
 */
class ShareholderStorage extends SqlContentEntityStorage implements ShareholderStorageInterface {

  /**
   * {@inheritdoc}
   */
  public function revisionIds(ShareholderInterface $entity) {
    return $this->database->query(
      'SELECT vid FROM {shareholder_revision} WHERE id=:id ORDER BY vid',
      [':id' => $entity->id()]
    )->fetchCol();
  }

  /**
   * {@inheritdoc}
   */
  public function userRevisionIds(AccountInterface $account) {
    return $this->database->query(
      'SELECT vid FROM {shareholder_field_revision} WHERE uid = :uid ORDER BY vid',
      [':uid' => $account->id()]
    )->fetchCol();
  }

  /**
   * {@inheritdoc}
   */
  public function countDefaultLanguageRevisions(ShareholderInterface $entity) {
    return $this->database->query('SELECT COUNT(*) FROM {shareholder_field_revision} WHERE id = :id AND default_langcode = 1', [':id' => $entity->id()])
      ->fetchField();
  }

  /**
   * {@inheritdoc}
   */
  public function clearRevisionsLanguage(LanguageInterface $language) {
    return $this->database->update('shareholder_revision')
      ->fields(['langcode' => LanguageInterface::LANGCODE_NOT_SPECIFIED])
      ->condition('langcode', $language->getId())
      ->execute();
  }

}
