<?php

namespace Drupal\shareholder_register;

use Drupal\Core\Entity\ContentEntityStorageInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Language\LanguageInterface;
use Drupal\shareholder_register\Entity\ShareholderInterface;

/**
 * Defines the storage handler class for Shareholder entities.
 *
 * This extends the base storage class, adding required special handling for
 * Shareholder entities.
 *
 * @ingroup shareholder_register
 */
interface ShareholderStorageInterface extends ContentEntityStorageInterface {

  /**
   * Gets a list of Shareholder revision IDs for a specific Shareholder.
   *
   * @param \Drupal\shareholder_register\Entity\ShareholderInterface $entity
   *   The Shareholder entity.
   *
   * @return int[]
   *   Shareholder revision IDs (in ascending order).
   */
  public function revisionIds(ShareholderInterface $entity);

  /**
   * Gets a list of revision IDs having a given user as Shareholder author.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The user entity.
   *
   * @return int[]
   *   Shareholder revision IDs (in ascending order).
   */
  public function userRevisionIds(AccountInterface $account);

  /**
   * Counts the number of revisions in the default language.
   *
   * @param \Drupal\shareholder_register\Entity\ShareholderInterface $entity
   *   The Shareholder entity.
   *
   * @return int
   *   The number of revisions in the default language.
   */
  public function countDefaultLanguageRevisions(ShareholderInterface $entity);

  /**
   * Unsets the language for all Shareholder with the given language.
   *
   * @param \Drupal\Core\Language\LanguageInterface $language
   *   The language object.
   */
  public function clearRevisionsLanguage(LanguageInterface $language);

}
