<?php

namespace Drupal\shareholder_register\TwigExtension;

use Drupal\shareholder_register\ShareholderRegisterServiceInterface;

/**
 * Class ShareholderRegisterTwigExtension.
 */
class ShareholderRegisterTwigExtension extends \Twig_Extension {


   /**
    * Drupal\shareholder_register\ShareholderRegisterServiceInterface definition.
    *
    * @var ShareholderRegisterServiceInterface
    */
    protected $shareholderRegisterDefault;

   /**
    * Constructs a new ShareholderRegisterTwigExtension object.
    */
    public function __construct(ShareholderRegisterServiceInterface $shareholder_register_default) {
      $this->shareholderRegisterDefault = $shareholder_register_default;
    }

   /**
    * {@inheritdoc}
    */
    public function getTokenParsers() {
      return [];
    }

   /**
    * {@inheritdoc}
    */
    public function getNodeVisitors() {
      return [];
    }

   /**
    * {@inheritdoc}
    */
    public function getFilters() {
      return [];
    }

   /**
    * {@inheritdoc}
    */
    public function getTests() {
      return [];
    }

   /**
    * {@inheritdoc}
    */
    public function getFunctions() {
      return [
        new \Twig_SimpleFunction('getShareHashFields', [$this, 'getShareHashFields']),
      ];
    }

   /**
    * {@inheritdoc}
    */
    public function getOperators() {
      return [];
    }

   /**
    * {@inheritdoc}
    */
    public function getName() {
      return 'shareholder_register.twig.extension';
    }

    /**
     * {@inheritdoc}
     */
    public function getShareHashFields()
    {
      return $this->shareholderRegisterDefault->getShareHashFields();
    }
}
