<?php

namespace Drupal\Tests\shareholder_register\Kernel;

use Drupal\shareholder_register\Entity\Shareholder;
use Drupal\shareholder_register\Entity\ShareType;
use Drupal\shareholder_register\ShareholderRegisterService;

use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\shareholder_register\Traits\LoadRegisterTrait;

/**
 * Tests share conversions.
 *
 * @group shareholder_register
 */
class ShareConversionTest extends KernelTestBase {

  use LoadRegisterTrait;

  /**
   * Modules to enable.
   *
   * @var array
   */
  public static $modules = [
    'system',
    'user',
    'file',
    'text',
    'datetime',
    'simple_workflows',
    'shareholder_register',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp() {
    parent::setUp();
    $this->traitSetUp();
  }

  /**
   * Setup test register for negative transactions.
   */
  protected function loadTestRegister() {
    $register = $this->loadBasicRegister(
      [
        'shareholders' => [
          [
            'number' => 1,
          ],
        ],
        'transactions' => [
          [
            'quantity' => 5,
            'shareholder_number' => 1,
            'payment_date' => '2017-01-02',
            'validation_date' => '2017-02-02',
          ],
          [
            'quantity' => 5,
            'shareholder_number' => 1,
            'payment_date' => '2017-05-02',
            'validation_date' => '2017-06-02',
          ],
          [
            'quantity' => -5,
            'shareholder_number' => 1,
          ],
        ],
      ]);
    return $register;
  }

  /**
   * Test a share conversion.
   */
  public function testShareConversion() {
    $register = $this->loadTestRegister();

    $shareholder = Shareholder::load(reset($register['shareholder']));

    $type2 = ShareType::create([
           'name' => 'aandeel',
           'par_value' => 100,
    ]);
    $type2->save();

    foreach ($shareholder->getShareRevisionsAtDate('2018-02-01') as $s) {
      $this->assertEqual($s->getShareType()->id(), 1);
    }

    $updated_shares = ShareholderRegisterService::convertShares(
      reset($register['transactions'])->getShares(),
      [
        'share_type_id' => $type2->id(),
      ],
      '2017-12-15',
      'test'
    );

    foreach ($shareholder->getShareRevisionsAtDate('2018-02-01') as $s) {
      if ($s->getName() < 6) {
        $this->assertEqual($s->getShareType()->id(), $type2->id());
      }
      else {
        $this->assertEqual($s->getShareType()->id(), 1);
      }
    }

    $this->assertEqual(
      count($shareholder->getConversions()),
      1
    );

    $updated_shares = ShareholderRegisterService::convertShares(
      reset($register['transactions'])->getShares(),
      [
        'share_type_id' => 1, // Type 1 id
      ],
      '2018-01-01',
      'test'
    );

    $this->assertEqual(
      count($shareholder->getConversions()),
      2
    );

    // If the shares are transferred / repurchased between conversions.
    $repurchase = end($register['transactions']);
    $repurchase->actionValidate('2017-12-31');

    $this->assertEqual(
      count($shareholder->getConversions()),
      1
    );

  }

}
