<?php

namespace Drupal\Tests\shareholder_register\Kernel;

use Drupal\shareholder_register\Entity\ShareTransactionGroup;

use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\shareholder_register\Traits\LoadRegisterTrait;

/**
 * Tests share transaction group.
 *
 * @group shareholder_register
 */
class ShareTransactionGroupTest extends KernelTestBase {

  use LoadRegisterTrait;

  /**
   * Modules to enable.
   *
   * @var array
   */
  public static $modules = [
    'system',
    'user',
    'file',
    'text',
    'datetime',
    'simple_workflows',
    'shareholder_register',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp() {
    parent::setUp();
    $this->traitSetUp();
  }

  /**
   * Setup test register for negative transactions.
   */
  protected function loadTestRegister() {
    $register = $this->loadBasicRegister(
      [
        'shareholders' => [
          [
            'number' => 1,
          ],
        ],
        'transactions' => [
          [
            'quantity' => 5,
            'shareholder_number' => 1,
            'payment_date' => '2017-01-02',
            'validation_date' => '2017-02-02',
          ],
        ],
      ]);
    return $register;
  }

  /**
   * Test delete validated share transaction group.
   */
  public function testDeleteValidShareTransactionGroup() {
    $register = $this->loadTestRegister();

    $t = reset($register['transactions']);
    $g = $t->getTransactionGroup();
    $g->delete();

    $this->assertNotNull(ShareTransactionGroup::load($g->id()));
  }

}
