<?php

namespace Drupal\Tests\shareholder_register\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\shareholder_register\Traits\LoadRegisterTrait;

use Drupal\shareholder_register\Entity\ShareTransaction;

use Drupal\shareholder_register\Exception\ShareTransactionNegativeShareCountException;
use Drupal\shareholder_register\Exception\ShareTransactionNegativeShareCountAtDateException;

/**
 * Shareholder register tests.
 *
 * @group shareholder_register
 */
class ShareholderRegisterTest extends KernelTestBase {

  use LoadRegisterTrait;

  /**
   * Modules to enable.
   *
   * @var array
   */
  public static $modules = [
    'system',
    'user',
    'file',
    'text',
    'datetime',
    'simple_workflows',
    'shareholder_register'
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp() {
    parent::setUp();
    $this->traitSetUp();
  }

  /**
   * Setup test register for negative transactions.
   */
  protected function loadTestRegister() {
    $register = $this->loadBasicRegister(
      [
        'shareholders' => [
          [
            'number' => 1,
          ],
        ],
        'transactions' => [
          [
            'quantity' => 5,
            'shareholder_number' => 1,
            'payment_date' => '2019-02-02',
            'validation_date' => '2019-02-02',
          ],
          [
            'quantity' => 5,
            'shareholder_number' => 1,
            'payment_date' => '2020-02-02',
            'validation_date' => '2020-02-02',
          ],
        ],
      ]);
    return $register;
  }

  /**
   * Test for negative shares at date.
   */
  public function testNegativeQuantityAtDateException() {
    $register = $this->loadTestRegister();

    $t = ShareTransaction::create([
      'shareholder_id' => reset($register['shareholder']),
      'quantity' => -10,
    ]);

    $this->expectException(ShareTransactionNegativeShareCountAtDateException::class);
    $t->preValidateTransaction('2019-02-03');
  }

  /**
   * Test for negative shares at date.
   */
  public function testNegativeQuantityException() {
    $register = $this->loadTestRegister();

    $t = ShareTransaction::create([
      'shareholder_id' => reset($register['shareholder']),
      'quantity' => -15,
    ]);

    $this->expectException(ShareTransactionNegativeShareCountException::class);
    $t->preValidateTransaction('2020-02-03');
  }

}
