<?php

namespace Drupal\Tests\shareholder_register\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\shareholder_register\Traits\LoadRegisterTrait;

use Drupal\shareholder_register\Entity\Shareholder;

/**
 * Tests taxshelter claim creation.
 *
 * @group shareholder_register
 */
class ShareholderSharesAtDateTest extends KernelTestBase {

  use LoadRegisterTrait;

  /**
   * Modules to enable.
   *
   * @var array
   */
  public static $modules = [
    'system',
    'user',
    'file',
    'text',
    'datetime',
    'simple_workflows',
    'shareholder_register'
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp() {
    parent::setUp();
    $this->traitSetUp();
  }

  /**
   * Setup test register for negative transactions.
   */
  protected function loadTestRegister() {
    $register = $this->loadBasicRegister(
      [
        'shareholders' => [
          [
            'number' => 1,
          ],
        ],
        'transactions' => [
          [
            'quantity' => 5,
            'shareholder_number' => 1,
            'payment_date' => '2017-01-02',
            'validation_date' => '2017-02-02',
          ],
          [
            'quantity' => 5,
            'shareholder_number' => 1,
            'payment_date' => '2018-01-02',
            'validation_date' => '2018-02-02',
          ],
          [
            'quantity' => -5,
            'shareholder_number' => 1,
            'validation_date' => '2019-02-02',
          ],
          [
            'quantity' => -5,
            'shareholder_number' => 1,
            'validation_date' => '2020-02-02',
          ],
          [
            'quantity' => 5,
            'shareholder_number' => 1,
            'payment_date' => '2020-03-01',
            'validation_date' => '2020-03-03',
          ],
         // add an unvalidated repurchase with shares attached
          [
            'quantity' => -5,
            'shareholder_number' => 1,
          ],
        ],
      ]);

      end($register['transactions'])->attachSharesToTransaction('2020-03-15');

    return $register;
  }

  /**
   * Test the getSharesAtDate method.
   */
  public function testSharesAtDate() {
    $register = $this->loadTestRegister();

    $s = Shareholder::load(reset($register['shareholder']));

    $this->assertEqual(count($s->getSharesAtDate('2017-02-01')), 0, "Shares on 2017-02-01 should be 0");
    $this->assertEqual(count($s->getSharesAtDate('2017-02-02')), 5, "Shares on 2017-02-02 should be 5");
    $this->assertEqual(count($s->getSharesAtDate('2018-02-02')), 10, "Shares on 2018-02-02 should be 10");
    $this->assertEqual(count($s->getSharesAtDate('2019-02-02')), 5, "Shares on 2019-02-02 should be 5");
    $this->assertEqual(count($s->getSharesAtDate('2020-02-02')), 0, "Shares on 2020-02-02 should be 0");

    $this->assertEqual(count($s->getSharesAtDate('2020-04-01')), 5, "Shares on 2020-04-01 should be 5");
  }

  /**
   * Test the getSharesAtDate method using payment_date.
   */
  public function testSharesAtDateWithPaymentDate() {
    $register = $this->loadTestRegister();

    $s = Shareholder::load(reset($register['shareholder']));

    $this->assertEqual(count($s->getSharesAtDate('2017-01-01', NULL, TRUE)), 0, "Shares on 2017-01-01 should be 0");
    $this->assertEqual(count($s->getSharesAtDate('2017-01-02', NULL, TRUE)), 5, "Shares on 2017-01-02 should be 5");
    $this->assertEqual(count($s->getSharesAtDate('2018-01-01', NULL, TRUE)), 5, "Shares on 2018-01-01 should be 5");
    $this->assertEqual(count($s->getSharesAtDate('2018-01-02', NULL, TRUE)), 10, "Shares on 2018-01-02 should be 10");
    $this->assertEqual(count($s->getSharesAtDate('2019-02-02', NULL, TRUE)), 5, "Shares on 2019-02-02 should be 5");
    $this->assertEqual(count($s->getSharesAtDate('2020-02-02', NULL, TRUE)), 0, "Shares on 2020-02-02 should be 0");

    $this->assertEqual(count($s->getSharesAtDate('2020-04-01', NULL, TRUE)), 5, "Shares on 2020-04-01 should be 5");
  }

}
