<?php

namespace Drupal\Tests\shareholder_register\Traits;

use Drupal\shareholder_register\Entity\ShareType;
use Drupal\shareholder_register\Entity\ShareIssue;
use Drupal\shareholder_register\Entity\Shareholder;
use Drupal\shareholder_register\Entity\ShareTransaction;
use Drupal\shareholder_register\Entity\ShareTransactionGroupType;

/**
 * Provides methods to load shareholder register data.
 */
trait LoadRegisterTrait {

  /**
   * Setup test.
   */
  protected function traitSetUp() {
    $this->installEntitySchema('user');
    $this->installEntitySchema('shareholder');
    $this->installEntitySchema('share_transaction');
    $this->installEntitySchema('share_transaction_group');
    $this->installEntitySchema('share_transaction_group_type');
    $this->installEntitySchema('share');
    $this->installEntitySchema('share_issue');
    $this->installEntitySchema('share_type');
  }

  /**
   * Helper to load basic register data.
   */
  public function loadBasicRegister($data, $share_value = 100) {
    if (!ShareTransactionGroupType::load('issue')) {
      ShareTransactionGroupType::create([
          'id' => 'issue',
          'baseType' => 'issue',
          'label' => 'Issue'
      ])->save();
    }
    if (!ShareTransactionGroupType::load('transfer')) {
      ShareTransactionGroupType::create([
          'id' => 'transfer',
          'baseType' => 'transfer',
          'label' => 'Transfer'
      ])->save();
    }
    if (!ShareTransactionGroupType::load('repurchase')) {
      ShareTransactionGroupType::create([
          'id' => 'repurchase',
          'baseType' => 'redemption',
          'label' => 'Redemption'
      ])->save();
    }
    $type = ShareType::create([
           'name' => 'aandeel',
           'par_value' => $share_value,
    ]);
    $type->save();
    $issue = ShareIssue::create([
           'share_type_id' => $type->id(),
    ]);
    $issue->save();

    $shareholders = [];
    $i = 1;
    foreach ($data['shareholders'] as $shareholder_data) {
      $s = Shareholder::create($shareholder_data + [
             'number' => $i,
             'type' => 'natural_person',
             'address' => [
               'given_name' => 'test',
               'family_name' => 'test' . $i,
               'postal_code' => '1000',
               'locality' => 'test',
               'country_code' => 'BE',
             ],
      ]);
      $s->save();
      $shareholders[$s->getNumber()] = $s->id();
      $i++;
    }
    $transactions = [];
    foreach ($data['transactions'] as $transaction_data) {
      $transaction_data['shareholder_id'] = $shareholders[$transaction_data['shareholder_number']];
      $extra_data = [];
      if ($transaction_data['quantity'] > 0) {
        $extra_data['share_issue_id'] = $issue->id();
      }
      $t = ShareTransaction::create($transaction_data + $extra_data);
      $t->save();
      if (!empty($transaction_data['validation_date'])) {
        $t->actionValidate($transaction_data['validation_date']);
      }
      $transactions[] = ShareTransaction::load($t->id());
    }
    return [
      'shareholder' => $shareholders,
      'transactions' => $transactions,
      'type' => $type->id(),
      'issue' => $issue->id(),
    ];
  }

}
