# Customizations

## Overriding parts of the template

You can override any part of the template, like `variables`, `workflows` or individual job definitions.

## Variables

You can override any variable. The default values can be seen [here](https://git.drupalcode.org/project/gitlab_templates/-/blob/main/includes/include.drupalci.variables.yml).

```
variables:
  _TARGET_CORE: "10.2.0"
  _SHOW_ENVIRONMENT_VARIABLES: "1"
```

## Jobs

If you want to change the default behavior of some jobs, you just need to override that part of the job.

```
# Linting jobs are allowed to fail by default, let's change that below.
cspell:
  allow_failure: false
phpcs:
  allow_failure: false
phpstan:
  allow_failure: false
```

## References

If the part of the template that you are overriding uses in-template references, you don't need to replicate them in your overrides, you can just use the [!reference notation](https://docs.gitlab.com/ee/ci/yaml/yaml_optimization.html#reference-tags).

For example: `!reference [ .setup-webserver ]`

## Additional services

You can include any other service and configure it as you would do it in GitLab CI.

For example, let's add a redis server to the `phpunit` job.
```
phpunit:
  services:
    - !reference [ .with-database ]
    - !reference [ .with-chrome ]
    - name: redis:6
```

## Additional extensions or packages

You can use `apt-get` to install new packages. For example, `imagemagick` needs extra packages:
```
before_script:
  - apt-get update
  - apt-get install -y --no-install-recommends imagemagick
```

Or Redis needs the `redis` PHP extension:
```
.phpunit-base:
  before_script:
    - apt-get update
    - apt-get install -y --no-install-recommends $PHPIZE_DEPS
    - pecl install redis && docker-php-ext-enable redis
```

## Use your own base images

Installing many packages and other system changes can be slow. A separate image is faster, but needs to be maintained:
```
default:
  image:
    name: berdir/php-8.3-apache-extra:production
```

Where `berdir/php-8.3-apache-extra:production` Dockerfile would be something like this:
```
FROM drupalci/php-8.3-apache:production
RUN apt-get update && apt-get install -y ...
RUN pecl install redis && docker-php-ext-enable redis
```
