# Composer

The composer jobs are run automatically every time a related job needs something from `composer`.

You cannot skip them unless you skip testing for a given Drupal variant (current, previous, next).

## Updating dependencies when testing against future releases

When testing against future releases, dependencies may not be compatible with the target release, so will need help to enable the test.

### Lenient support

The variable `_LENIENT_ALLOW_LIST` can specify a comma-separated list of modules that composer dependencies on the core version will be ignored for. This is achieved using the [mglaman/composer-drupal-lenient](https://github.com/mglaman/composer-drupal-lenient) composer extension.

An example of this can be:
```
variables:
  OPT_IN_TEST_NEXT_MINOR: '1'
  OPT_IN_TEST_NEXT_MAJOR: '1'
  OPT_IN_TEST_MAX_PHP: '1'

composer (next minor):
  variables:
    _LENIENT_ALLOW_LIST: token

composer (next major):
  variables:
    _LENIENT_ALLOW_LIST: entity_reference_revisions,inline_entity_form,paragraphs,token
```

In this example, the lenient plugin will NOT be used in the regular composer task. But it will be used for the next minor and next major with different lists of projects that are allowed, even if those projects are not compatible with the new release.


### Composer patches

Sometimes, you may need to install a patch for a dependent module to allow tests to pass.

To this, add a JSON file containing patches, and specify it in the `_COMPOSER_PATCHES_FILE` variable. For example:
```
composer (next major):
  variables:
    _LENIENT_ALLOW_LIST: token
    _COMPOSER_PATCHES_FILE: .gitlab-ci/nextmajor_patches.json
```

We recommend placing the patches within the `.gitlab-ci` folder inside your module.

Additional information on the patch file can be found in the [Composer Patches documentation](https://docs.cweagans.net/composer-patches//usage/defining-patches/#patches-file).

### Package versions

The templates will favor the `drupal/core-recommended` package when installing Drupal, which does NOT include a `composer.lock` file. This is expected and is the recommended usage for most cases.

If your module relies on specific versions of certain packages from core you need to update your module's `composer.json` to declare this.
