# ESLint

If the module has `.js` or `.yml` files, then [eslint](https://eslint.org/) will be run to validate coding standards for these files.

Your project does not need a `.eslintrc.json` file because a default one matching Core's standards `core/.eslintrc.passing.json` is used. If you do create a `.eslintrc.json` file then it only needs to contain the specific rules that you want to override, because all other rules will be inherited due to ESLint's cascading configuration.

You can pass additional options to the `eslint` call via the `_ESLINT_EXTRA` variable. This variable has a default value of `--quiet` to match what Drupal core does.

If there are `.js` or `.yml` files that you do not want to fix, or cannot fix for whatever reason, these can be ignored by adding the names to a `.eslintignore` file stored in your project top-level folder. Files and paths listed here will be completely ignored for both ESLint and Prettier checking. An example where this would be needed is if you have minified javascript files.
```
# Ignore all minified javascript files
**/*.min.js
```

## Prettier

"Prettier" processing is the part of ESLint that is concerned with formatting and file layout, for both `.js` and `.yml` files. Formatting rules follow the definitions used by Drupal Core as defined in `core/.prettierrc.json`. This is the default, but projects can have their own definitions in a `.prettierrc.json` file which will be used instead of the core rules. Unlike ESLint, the Prettier rules do not use cascading configuration, so if you do have a `.prettierrc.json` file it must contain all the rules that you want your project to follow.

If there are files that you do not want to fix, or cannot fix, for Prettier formatting, these can be ignored by adding the file paths to a `.prettierignore` file. An example where this is needed is the Config and Views files exported from UI, as these do not follow the Prettier formatting rules. So rather than manually edit the exported files, they can be ignored for Prettier formatting (but still be checked for ESLint standards).
```
config/*/views.*.yml
tests/modules/*/config/install/*.yml
```

## Fixing the reported problems

If there are standards and formatting errors that can be fixed automatically, you will get a useful artifact named `_eslint.patch` which you can run against your module's code to fix the issues that were found.
