# PHPUnit

It will run the tests of your module using [phpunit](https://phpunit.de/index.html), but there are two flavors that you can choose from:

- Using the `phpunit` binary directly and running the tests in sequential mode. `_PHPUNIT_CONCURRENT: 0` (default).
- Using the `run-tests.sh` Drupal core script and running the tests in parallel mode. `_PHPUNIT_CONCURRENT: 1`.

## Using `phpunit` binary directly.

This is the default option. The tests will be run calling the `vendor/bin/phpunit` binary directly and in a sequential order. As there is no concurrency, the tests here might take a bit longer.

You can use the `_PHPUNIT_EXTRA` variable to add extra options to the `phpunit` binary.

### TestDox

An example of one of the `phpunit`-only options is TestDox. If you want nicer CI terminal output you can set or add the option `--testdox` to the variable `_PHPUNIT_EXTRA`. The output will change from the typical
```
.............. (14/14)
```
to a more detailed output showing each test name and class, for example:
```
Admin Pages (Drupal\Tests\api\Functional\AdminPages)
 ✔ Admin pages
Api Access (Drupal\Tests\api\Functional\ApiAccess)
 ✔ Access
 ✔ Branch objects
 ...
```
Note that this option conflicts with the Drupal `HtmlOutputPrinter` printer and, if used, no `.html` artifacts will be generated after the run.

## Using `run-tests.sh` core script (concurrent mode)

This script is included in Drupal core and leverages concurrency and also runs the tests in the same way that Drupal core tests are run. As there is concurrency, the job should run quicker than with the sequential option.

To enable concurrent mode set the variable `_PHPUNIT_CONCURRENT` to `1`.

In this case, the `_PHPUNIT_EXTRA` variable will contain options compatible with the `run-test.sh` script. You can also add [parallel](https://docs.gitlab.com/ee/ci/yaml/#parallel) or [parallel:matrix](https://docs.gitlab.com/ee/ci/yaml/#parallelmatrix) options to the job definition, to split out the tests into multiple jobs running in parallel.

If you want to split evenly the tests that are run in each _parallel_ job, you can do it like this:

```
variables:
  _PHPUNIT_EXTRA: "--ci-parallel-node-index $CI_NODE_INDEX --ci-parallel-node-total $CI_NODE_TOTAL"

phpunit:
  parallel: 3
```

## Variants

This job allows for multiple variants to check previous, current and future versions of Drupal.

## Deprecations

By default, we are setting `SYMFONY_DEPRECATIONS_HELPER` to `weak`. This will not report warnings or deprecations by default.

If you want to mirror what core does, you can do it like this:
```
phpunit:
  variables:
    SYMFONY_DEPRECATIONS_HELPER: "ignoreFile=$CI_PROJECT_DIR/$_WEB_ROOT/core/.deprecation-ignore.txt"
```

In addition to the above, you will need to make sure that your `phpunit.(dist.)xml` file contains the `DrupalListener`:
```
 <?xml version="1.0" encoding="UTF-8"?>
 <phpunit xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
   <listeners>
     <listener class="\Drupal\Tests\Listeners\DrupalListener">
     </listener>
   </listeners>
 </phpunit>
```

If you want to have your own file to include other deprecations, like third party ones, you can create your own file and call it like this:
```
phpunit:
  variables:
    SYMFONY_DEPRECATIONS_HELPER: "ignoreFile=./.local-deprecation-ignore.txt"
```
