# Test-only changes

The purpose of this job is to run only the tests that have been modified in a Merge Request. All the non-test files are reverted back to their unchanged state.

This is a way to demonstrate that the changes in the tests provide test coverage for the feature/bug/problem which is being worked on. It is equivalent to the "test-only will fail" patches that have been used on DrupalCI for contrib projects and for core over the past years. Drupal Core already has a 'test-only changes' GitLab pipeline job, but this feature is new for contrib projects.

This job is only created in Merge Request pipelines, it will not appear in branch or scheduled pipelines. It will only be created if the merge request actually contains changes to phpunit test files.

It is `manual`, which means it will not start automatically but will require you to click the `[>]` 'play' button.

The log has extra information showing which files have been changed in the merge request and which files have been reverted before running the tests. The job is intended to fail with an amber warning, as this demonstrates that the modified tests do provide test coverage for the problem being fixed.

If this job ends with a green pass it means that the bug or feature does not have test coverage, because the tests pass even with unmodified source files.

If you chose not to trigger the job at all, your pipeline result will not be affected.
