#!/bin/bash

# Launch from the root of this project: "./scripts/run-local-checks.sh [clean]".
#
# Helper script to run all the checks that will be run via GitLab CI.
#
# It assumes that you have:
# - node (version 18+)
# - npm (version 9+)
# - composer 2
# - shellcheck

# Copy configuration files for the tools.
cp -a ./assets/internal/. .

# Run the tools.
npm install
composer install
npx cspell --show-suggestions --show-context --no-progress **
npx eslint --no-error-on-unmatched-pattern --ignore-pattern="docs/**" --ext=.yml .
vendor/bin/phpcs scripts/*.php -s
shellcheck scripts/*.sh

# Clean up all files that were copied.
if [[ "$1" == "clean" ]]; then
  rm -rf node_modules/ vendor/
  rm .cspell.json .eslintrc.js .shellcheckrc .project-words.txt composer.json composer.lock package.json package-lock.json phpcs.xml
fi
