<?php

/**
 * @file
 * Contains bank_order.page.inc.
 *
 * Page callback for Bank order entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Bank order templates.
 *
 * Default template: bank_order.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_bank_order(array &$variables) {
  // Fetch BankOrder Entity Object.
  $bank_order = $variables['elements']['#bank_order'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
