<?php

/**
 * @file
 * Contains bank_order_line.page.inc.
 *
 * Page callback for Bank order line entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Bank order line templates.
 *
 * Default template: bank_order_line.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_bank_order_line(array &$variables) {
  // Fetch BankOrderLine Entity Object.
  $bank_order_line = $variables['elements']['#bank_order_line'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
