<?php

namespace Drupal\banking_orders;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Bank order entity.
 *
 * @see \Drupal\banking_orders\Entity\BankOrder.
 */
class BankOrderAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\banking_orders\Entity\BankOrderInterface $entity */

    switch ($operation) {

      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view all bank order entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit bank order entities');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete bank order entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add bank order entities');
  }

}
