<?php

namespace Drupal\banking_orders;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Bank order line entities.
 *
 * @ingroup banking_orders
 */
class BankOrderLineListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['name'] = $this->t('Name');
    $header['order'] = $this->t('Bank Order');
    $header['account_holder'] = $this->t('Account holder');
    $header['account_number'] = $this->t('Account number');
    $header['amount'] = $this->t('Amount');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\banking_orders\Entity\BankOrderLine $entity */
    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.bank_order_line.edit_form',
      ['bank_order_line' => $entity->id()]
    );
    $row['order'] = $entity->getOrder() ? $entity->getOrder()->label() : '';
    $row['account_holder'] = $entity->getAccountHolder();
    $row['account_number'] = $entity->getAccountNumber();
    $row['amount'] = $entity->getAmount();
    return $row + parent::buildRow($entity);
  }

}
