<?php

namespace Drupal\banking_orders;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Bank order entities.
 *
 * @ingroup banking_orders
 */
class BankOrderListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['name'] = $this->t('Name');
    $header['bank_account'] = $this->t('Bank Account');
    $header['amount'] = $this->t('Amount');
    $header['state'] = $this->t('State');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\banking_orders\Entity\BankOrder $entity */
    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.bank_order.canonical',
      ['bank_order' => $entity->id()]
    );
    $row['bank_account'] = $entity->getBankAccount() ? $entity->getBankAccount()->label() : '';
    $row['amount'] = $entity->getAmount();
    $row['state'] = $entity->getState();
    return $row + parent::buildRow($entity);
  }

}
