<?php

namespace Drupal\banking_orders\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;

/**
 * Provides an interface for defining Bank order entities.
 *
 * @ingroup banking_orders
 */
interface BankOrderInterface extends ContentEntityInterface, EntityChangedInterface {

  /**
   * Add get/set methods for your configuration properties here.
   */

  /**
   * Gets the Bank order name.
   *
   * @return string
   *   Name of the Bank order.
   */
  public function getName();

  /**
   * Sets the Bank order name.
   *
   * @param string $name
   *   The Bank order name.
   *
   * @return \Drupal\banking_orders\Entity\BankOrderInterface
   *   The called Bank order entity.
   */
  public function setName($name);

  /**
   * Gets the Bank order creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Bank order.
   */
  public function getCreatedTime();

  /**
   * Sets the Bank order creation timestamp.
   *
   * @param int $timestamp
   *   The Bank order creation timestamp.
   *
   * @return \Drupal\banking_orders\Entity\BankOrderInterface
   *   The called Bank order entity.
   */
  public function setCreatedTime($timestamp);

}
