<?php

namespace Drupal\banking_orders\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;

/**
 * Provides an interface for defining Bank order line entities.
 *
 * @ingroup banking_orders
 */
interface BankOrderLineInterface extends ContentEntityInterface, EntityChangedInterface {

  /**
   * Add get/set methods for your configuration properties here.
   */

  /**
   * Gets the Bank order line name.
   *
   * @return string
   *   Name of the Bank order line.
   */
  public function getName();

  /**
   * Sets the Bank order line name.
   *
   * @param string $name
   *   The Bank order line name.
   *
   * @return \Drupal\banking_orders\Entity\BankOrderLineInterface
   *   The called Bank order line entity.
   */
  public function setName($name);

  /**
   * Gets the Bank order line creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Bank order line.
   */
  public function getCreatedTime();

  /**
   * Sets the Bank order line creation timestamp.
   *
   * @param int $timestamp
   *   The Bank order line creation timestamp.
   *
   * @return \Drupal\banking_orders\Entity\BankOrderLineInterface
   *   The called Bank order line entity.
   */
  public function setCreatedTime($timestamp);

}
