<?php

namespace Drupal\banking_orders\Form;

use Drupal\Core\Entity\ContentEntityDeleteForm;
use Drupal\Core\Form\FormStateInterface;

use Drupal\banking\Exception\BankingIntegrityException;

/**
 * Provides a form for deleting Bank order line entities.
 *
 * @ingroup banking_orders
 */
class BankOrderLineDeleteForm extends ContentEntityDeleteForm {

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    try {
      parent::submitForm($form, $form_state);
    }
    catch (BankingIntegrityException $e) {
      $this->messenger()->addError(
        $this->t(
          $e->getMessage(),
          $e->getMsgPlaceholders()
        )
      );
    }
  }

}
