<?php

namespace Drupal\banking_orders\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormState;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormInterface;

use Drupal\Component\Utility\NestedArray;

use Drupal\banking_orders\Entity\BankOrder;

/**
 * Form to createB Bank Orders using plugins.
 */
class CreateBankOrderForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'create_bank_order_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $this->manager = \Drupal::service('plugin.manager.create_bank_order_plugin');

    $create_bank_order_plugin_manager = \Drupal::service('plugin.manager.create_bank_order_plugin');
    $create_options = array_column($create_bank_order_plugin_manager->getDefinitions(), 'label', 'id');

    // $wrapper_id = Html::getUniqueId('ajax-wrapper');
    $wrapper_id = 'ajax-wrapper';

    $form['name'] = [
      '#weight' => '5',
      '#type' => 'textfield',
      '#title' => $this->t('Name'),
      '#required' => TRUE,
    ];
    $form['bank_account'] = [
      '#weight' => '10',
      '#type' => 'entity_autocomplete',
      '#title' => $this->t('Bank Account'),
      '#description' => $this->t('The Bank Account'),
      '#required' => TRUE,
      '#target_type' => 'bank_account',
    ];

    $form['plugin'] = [
      '#type' => 'select',
      '#title' => $this->t('Plugin'),
      '#options' => $create_options,
      '#weight' => '15',
      '#required' => TRUE,
      '#ajax' => [
        'callback' => [get_called_class(), 'updatePlugin'],
        'wrapper' => $wrapper_id,
      ],
    ];
    $form['plugin_settings_wrapper'] = [
      '#weight' => '20',
      '#tree' => TRUE,
      '#prefix' => '<div id="' . $wrapper_id . '">',
      '#suffix' => '</div>',
    ];

    if ($form_state->getValue('plugin')) {
      $plugin_id = $form_state->getValue('plugin');
      $plugin_values = $form_state->getValue(['plugin_settings_wrapper']);
      $plugin = $this->manager->createInstance($plugin_id, $plugin_values ? $plugin_values : []);
      if ($plugin instanceof PluginFormInterface) {
        $form['plugin_settings_wrapper'] += $plugin->buildConfigurationForm([], $form_state);
      }
    }

    $form['submit'] = [
      '#weight' => '50',
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public static function updatePlugin(array $form, FormStateInterface $form_state) {
    $subform = NestedArray::getValue($form, ['plugin_settings_wrapper']);
    return $subform;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    $this->manager = \Drupal::service('plugin.manager.create_bank_order_plugin');
    if ($form_state->getValue('plugin')) {
      $plugin_id = $form_state->getValue('plugin');
      $plugin = $this->manager->createInstance($plugin_id, []);
      $plugin_values = $form_state->getValue(['plugin_settings_wrapper']);
      if ($plugin_values) {
        $plugin->validateConfigurationForm($form, $form_state);
      }
    }
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $form_state->setRedirect('entity.bank_order.collection');

    // If we're dealing with a form, submit it.
    $this->manager = \Drupal::service('plugin.manager.create_bank_order_plugin');
    if ($form_state->getValue('plugin')) {
      $plugin_id = $form_state->getValue('plugin');
      $plugin = $this->manager->createInstance($plugin_id, []);
      $plugin_values = $form_state->getValue(['plugin_settings_wrapper']);
      if ($plugin_values) {
        $sub_form_state = new FormState();
        $sub_form_state->setValues($plugin_values);
        $plugin->submitConfigurationForm($form, $sub_form_state);
      }
    }

    $order = BankOrder::create([
      'name' => $form_state->getValue('name'),
      'bank_account' => $form_state->getValue('bank_account'),
    ] + $plugin->getBankOrderData());
    $order->save();

    $batch = $plugin->getAddBankOrderLinesBatch($order);
    batch_set($batch);
  }

}
