<?php

namespace Drupal\banking_orders\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Provides the Bank order export plugin plugin manager.
 */
class BankOrderExportPluginManager extends DefaultPluginManager {

  /**
   * Constructs a new BankOrderExportPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/BankOrderExportPlugin', $namespaces, $module_handler, 'Drupal\banking_orders\Plugin\BankOrderExportPluginInterface', 'Drupal\banking_orders\Annotation\BankOrderExportPlugin');

    $this->alterInfo('banking_orders_bank_order_export_plugin_info');
    $this->setCacheBackend($cache_backend, 'banking_orders_bank_order_export_plugin_plugins');
  }

  /**
   * {@inheritdoc}
   */
  public function getApplicableDefinitions($bank_order_type) {
    return array_filter(
      $this->getDefinitions(),
      function ($d) use ($bank_order_type) {
        return in_array($bank_order_type, $d['types']);
      }
    );
  }

}
