<?php

namespace Drupal\banking_orders\Plugin;

use Symfony\Component\DependencyInjection\ContainerInterface;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Base class for Create bank order plugin plugins.
 */
abstract class CreateBankOrderPluginBase extends PluginBase implements CreateBankOrderPluginInterface, ContainerFactoryPluginInterface {
  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function getBankOrderData() {
    return [
      'order_type' => 'credit',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static($configuration, $plugin_id, $plugin_definition);
  }

}
