<?php

namespace Drupal\banking_orders\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;

use Drupal\banking_orders\Entity\BankOrder;

/**
 * Defines an interface for Create bank order plugin plugins.
 */
interface CreateBankOrderPluginInterface extends PluginInspectionInterface {

  /**
   * Return batch definition to export the order.
   */
  public function getAddBankOrderLinesBatch(BankOrder $order);

  /**
   * Return default values for the created Bank Order.
   */
  public function getBankOrderData();

}
