<?php

namespace Drupal\banking_orders\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Provides the Create bank order plugin plugin manager.
 */
class CreateBankOrderPluginManager extends DefaultPluginManager {

  /**
   * Constructs a new CreateBankOrderPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/CreateBankOrderPlugin', $namespaces, $module_handler, 'Drupal\banking_orders\Plugin\CreateBankOrderPluginInterface', 'Drupal\banking_orders\Annotation\CreateBankOrderPlugin');

    $this->alterInfo('banking_orders_create_bank_order_plugin_info');
    $this->setCacheBackend($cache_backend, 'banking_orders_create_bank_order_plugin_plugins');
  }

}
