<?php

namespace Drupal\banking_orders\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\banking_orders\Entity\BankOrderLine;

/**
 * Plugin implementation of the 'bank_order_line_formatter' formatter.
 *
 * @FieldFormatter(
 *   id = "bank_order_line_formatter",
 *   label = @Translation("Bank Order Line Formatter"),
 *   field_types = {
 *     "bank_order_line"
 *   }
 * )
 */
class BankOrderLineFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings() {
    return [
      // Implement default settings.
    ] + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    return [
      // Implement settings form.
    ] + parent::settingsForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    // Implement settings summary.
    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements[0] = [
      '#type' => 'table',
      '#cache' => [
        'tags' =>
        \Drupal::entityTypeManager()->getDefinition('bank_order_line')->getListCacheTags(),
      ],
      '#header' => [
        $this->t('Account holder'),
        $this->t('IBAN'),
        $this->t('Message'),
        $this->t('Amount'),
      ],
    ];

    foreach ($items as $delta => $item) {
      $elements[0]['#rows'][$delta] = $this->viewValue($item);
    }

    return $elements;
  }

  /**
   * Generate the output appropriate for one field item.
   *
   * @param \Drupal\Core\Field\FieldItemInterface $item
   *   One field item.
   *
   * @return string
   *   The textual output generated.
   */
  protected function viewValue(FieldItemInterface $item) {
    $value = $item->getValue();
    if (isset($value['entity'])) {
      $entity = $value['entity'];
    }
    else {
      $entity = BankOrderLine::load($value['target_id']);
    }

    return [
      'account_holder' => $entity->getAccountHolder(),
      'iban' => $entity->getAccountNumber(),
      'message' => $entity->getName(),
      'amount' => $entity->getAmount(),
    ];
  }

}
