<?php

namespace Drupal\banking_orders\Plugin\Field\FieldType;

use Drupal\Core\Field\EntityReferenceFieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

use Drupal\banking_orders\Entity\BankOrderLine;

/**
 * {@inheritdoc}
 */
class BankOrderLineItemList extends EntityReferenceFieldItemList {
  use ComputedItemListTrait;

  /**
   * Compute the values.
   */
  protected function computeValue() {
    $entity = $this->getEntity();

    $values = BankOrderLine::loadMultiple(
      \Drupal::entityQuery('bank_order_line')
        ->accessCheck(FALSE)
        ->condition('bank_order_id', $entity->id())
        ->execute()
    );

    if ($values) {
      $n = 0;
      foreach ($values as $delta => $value) {
        $this->list[$n] = $this->createItem($delta, $value);
        $n++;
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function referencedEntities() {
    $this->ensureComputedValue();
    return parent::referencedEntities();
  }

  /**
   * {@inheritdoc}
   */
  public function getReferencedEntities() {
    // Duplicate method, with prefix get for use in twig templates.
    $this->valueComputed = FALSE;
    return $this->referencedEntities();
  }

}
