<?php

namespace Drupal\banking_orders\Plugin\WorkflowType;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\workflows\Plugin\WorkflowTypeBase;

/**
 * Bank Order workflow type.
 *
 * @WorkflowType(
 *   id = "workflow_bank_order",
 *   label = @Translation("Bank Order Workflow"),
 *   required_states = {
 *     "draft",
 *     "done",
 *   }
 * )
 */
class BankOrderWorkflowType extends WorkflowTypeBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'states' => [
        'draft' => [
          'label' => 'Draft',
          'weight' => 0,
        ],
        'done' => [
          'label' => 'Done',
          'weight' => 2,
        ],
      ],
      'transitions' => [
        'validate' => [
          'label' => 'Validate',
          'to' => 'done',
          'weight' => 0,
          'from' => [
            'draft',
          ],
        ],
      ],
    ];
  }

}
