<?php

namespace Drupal\Tests\banking_orders\Kernel;

use Drupal\KernelTests\KernelTestBase;

use Drupal\banking_orders\Entity\BankOrder;
use Drupal\banking_orders\Entity\BankOrderLine;

use Drupal\banking\Exception\BankingIntegrityException;

/**
 * Banking Order tests.
 *
 * @group banking
 */
class BankingOrderIntegrityTest extends KernelTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'system',
    'user',
    'file',
    'text',
    'datetime',
    'iban_bic_field',
    'simple_workflows',
    'banking',
    'banking_orders',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installEntitySchema('user');
    $this->installEntitySchema('bank_order');
    $this->installEntitySchema('bank_order_line');
  }

  /**
   * Test delete non-draft bank order.
   */
  public function testDeleteBankOrder() {
    $o = BankOrder::create([
      'name' => 'test',
    ]);
    $o->set('state', 'valid')->save();

    $this->expectException(BankingIntegrityException::class);
    $o->delete();
  }

  /**
   * Test delete non-draft bank order line.
   */
  public function testDeleteBankOrderLine() {
    $o = BankOrder::create([
      'name' => 'test',
    ]);
    $o->set('state', 'valid')->save();

    $l = BankOrderLine::create([
      'name' => 'test',
      'bank_order_id' => $o->id(),
    ]);
    $l->save();

    $this->expectException(BankingIntegrityException::class);
    $l->delete();
  }

}
