<?php

namespace Drupal\ticketmatic_api\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

use Ticketmatic\Client;
use Ticketmatic\Endpoints\Tools;

/**
 * Configure TicketMatic API settings for this site.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ticketmatic_api_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['ticketmatic_api.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['account'] = [
      '#type' => 'textfield',
      '#title' => $this->t('TicketMatic Account Name'),
      '#default_value' => $this->config('ticketmatic_api.settings')->get('account'),
    ];
    $form['access_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('TicketMatic Access Key'),
      '#default_value' => $this->config('ticketmatic_api.settings')->get('access_key'),
    ];
    $form['secret_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('TicketMatic Secret Key'),
      '#default_value' => $this->config('ticketmatic_api.settings')->get('secret_key'),
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    if ($form_state->getValue('account')) {
      $client = new Client(
        $form_state->getValue('account'),
        $form_state->getValue('access_key'),
        $form_state->getValue('secret_key')
      );
      try {
        Tools::account($client);
      }
      catch (\Exception $e) {
        $form_state->setErrorByName(
          'account',
          $e->getMessage()
        );
      }
    }
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('ticketmatic_api.settings')
      ->set('account', $form_state->getValue('account'))
      ->set('access_key', $form_state->getValue('access_key'))
      ->set('secret_key', $form_state->getValue('secret_key'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
