<?php

namespace Drupal\ticketmatic_api\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Component\Render\FormattableMarkup;
use Drupal\Core\Url;

/**
 * Plugin implementation of the 'ticketmatic_id_formatter' formatter.
 *
 * @FieldFormatter(
 *   id = "ticketmatic_id_formatter",
 *   label = @Translation("TicketMatic ID"),
 *   field_types = {
 *     "ticketmatic_id"
 *   }
 * )
 */
class TicketMaticIdFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($items as $delta => $item) {
      if (!$item->isEmpty()) {
        $link = 'invalid';
        try {
          $link = Url::fromUri(
            (new FormattableMarkup(
              $item->getTicketMaticLink(),
              [
                '@id' => $item->value,
              ]
            ))->__toString()
          );
        }
        catch (\Exception $ex) {
          // Log ?
        }
        $elements[$delta] = [
          '#type' => 'link',
          '#url' => $link,
          '#title' => $this->t('TicketMatic'),
        ];
      }
    }

    return $elements;
  }

}
