<?php

namespace Drupal\ticketmatic_api\Plugin\Field\FieldType;

use Drupal\Core\Field\Plugin\Field\FieldType\IntegerItem;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin implementation of the 'druplan_project_events' field type.
 *
 * @FieldType(
 *   id = "ticketmatic_id",
 *   label = @Translation("TicketMatic ID"),
 *   description = @Translation("TicketMatic ID"),
 *   default_formatter = "ticketmatic_id_formatter"
 * )
 */
class TicketMaticIdItem extends IntegerItem {

  /**
   * {@inheritdoc}
   */
  public static function defaultFieldSettings() {
    return [
      'ticketmatic_object' => 'contact',
    ] + parent::defaultFieldSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function fieldSettingsForm(array $form, FormStateInterface $form_state) {
    $element = [];

    $options = [
      'contact' => $this->t('Relation'),
      'event' => $this->t('Event'),
    ];

    $element['ticketmatic_object'] = [
      '#type' => 'select',
      '#title' => $this->t('Ticketmatic Object'),
      '#selection' => $options,
      '#default_value' => $this->getSetting('ticketmatic_object'),
    ];

    return $element;
  }

  /**
   * Get plain text link to ticketmatic object.
   */
  public function getTicketMaticLink() {
    if ($this->getSetting('ticketmatic_object') == 'event') {
      return 'https://apps.ticketmatic.com/#!/events/@id/settings';
    }
    elseif ($this->getSetting('ticketmatic_object') == 'contact') {
      return 'https://apps.ticketmatic.com/#!/crm/contacts/@id';
    }
    else {
      return '';
    }
  }

}
