<?php

namespace Drupal\ticketmatic_api;

use Drupal\Core\Config\ConfigFactoryInterface;

use Ticketmatic\Client;
use Ticketmatic\Endpoints\Events;


/**
 * Service connecting to the TicketMatic Api.
 */
class TicketMaticApi {

  const TS_FORMAT = "Y-m-d H:i:s";

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a TicketMaticApi object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * Get a TicketMatic client.
   */
  public function getClient() {
    $config = $this->configFactory->get('ticketmatic_api.settings');
    return new Client(
      $config->get('account'),
      $config->get('access_key'),
      $config->get('secret_key'),
    );
  }

  /**
   * Create a TicketMatic event.
   */
  public function createEvent($data) {
    $event = Events::create(
      $this->getClient(),
      $data);
    return $event;
  }
}
